?php

namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class AdminTyping implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $admin_id;
    public $user_id;

    public function __construct($admin_id, $user_id)
    {
        $this->admin_id = $admin_id;
        $this->user_id = $user_id;
    }

    public function broadcastOn()
    {
        return new Channel('chat');
    }
}