<?php

namespace App\Livewire\Admin\ManageUsers;

use App\Models\Transaction;
use App\Models\User;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class AdjustAccount extends Component
{
    use LivewireAlert;

    public $options = [
        'balance' => 'Account Balance',
        'Bonus' => 'Bonus',
        'Ref_Bonus' => 'Referral Bonus',
        'Profit' => 'Profit (ROI)',
    ];
    public $column = 'balance';
    public $amount;
    public $adjustment = 'Credit';
    public $history = 'Yes';
    public User $user;

    public function render()
    {
        return view('livewire.admin.manage-users.adjust-account');
    }

    public function adjustAccount(): void
    {
        $this->authorize('edit user');
        
        if ($this->adjustment === 'Debit') {
            if ($this->column === 'balance' && $this->user->account_bal < $this->amount) {
                $this->alert(type: 'warning', message: 'User Account Balance is insufficient for this operation.');
                return;
            }
            if ($this->column === 'Bonus' && $this->user->bonus < $this->amount) {
                $this->alert(type: 'warning', message: 'User Bonus is insufficient for this operation.');
                return;
            }
            if ($this->column === 'Ref_Bonus' && $this->user->ref_bonus < $this->amount) {
                $this->alert(type: 'warning', message: 'User Referral Bonus is insufficient for this operation.');
                return;
            }
            if ($this->column === 'Profit' && $this->user->roi < $this->amount) {
                $this->alert(type: 'warning', message: 'User Profit is insufficient for this operation.');
                return;
            }
        }

        if ($this->adjustment === 'Credit') {
            if ($this->column === 'balance') {
                $this->user->account_bal += $this->amount;
            } elseif ($this->column === 'Bonus') {
                $this->user->bonus += $this->amount;
            } elseif ($this->column === 'Ref_Bonus') {
                $this->user->ref_bonus += $this->amount;
            } elseif ($this->column === 'Profit') {
                $this->user->roi += $this->amount;
            }
        } else { // Debit
            if ($this->column === 'balance') {
                $this->user->account_bal -= $this->amount;
            } elseif ($this->column === 'Bonus') {
                $this->user->bonus -= $this->amount;
            } elseif ($this->column === 'Ref_Bonus') {
                $this->user->ref_bonus -= $this->amount;
            } elseif ($this->column === 'Profit') {
                $this->user->roi -= $this->amount;
            }
        }

        $this->user->save();

        if ($this->history === 'Yes') {
            Transaction::create([
                'user_id' => $this->user->id,
                'narration' => "{$this->column}",
                'amount' => $this->amount,
                'type' => $this->adjustment,
            ]);
        }

        $this->reset(['amount', 'column', 'adjustment', 'history']);

        $this->dispatch('refreshp');
        $this->alert(message: 'Account Adjusted Successfully');
    }
}
