<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lesson extends Model
{
    use HasFactory;

    protected $fillable = [
        'category',
        'title',
        'description',
        'video_link',
        'length',
        'preview',
        'thumbnail',
        'course_id',
    ];

    /**
     * Relationship with Course
     */
    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    /**
     * Accessor for Preview Attribute
     * Converts boolean to string for dropdown (true/false).
     */
    public function getPreviewAttribute($value)
    {
    return (bool) $value ? 'true' : 'false';
    }

    /**
     * Set thumbnail path dynamically
     */
    public function getThumbnailUrlAttribute()
    {
        return str_starts_with($this->thumbnail, 'http') 
            ? $this->thumbnail 
            : asset('storage/' . $this->thumbnail);
    }
}
