<!-- resources/views/admin/annual-reports/create.blade.php -->
<x-app-layout>
   <div class="col-12">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Add New Annual Report</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.annual-reports.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="name" class="form-label">Report Name</label>
                        <input type="text" 
                               class="form-control @error('name') is-invalid @enderror" 
                               id="name" 
                               name="name" 
                               value="{{ old('name') }}" 
                               required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="report_year" class="form-label">Report Year</label>
                        <input type="number" 
                               class="form-control @error('report_year') is-invalid @enderror" 
                               id="report_year" 
                               name="report_year" 
                               value="{{ old('report_year') }}" 
                               min="1900" 
                               max="{{ date('Y') + 1 }}" 
                               required>
                        @error('report_year')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="col-12 mb-3">
                        <label for="pdf_file" class="form-label">PDF File</label>
                        <input type="file" 
                               class="form-control @error('pdf_file') is-invalid @enderror" 
                               id="pdf_file" 
                               name="pdf_file" 
                               accept=".pdf" 
                               required>
                        <div class="form-text">Maximum file size: 10MB</div>
                        @error('pdf_file')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.annual-reports.index') }}" class="btn btn-secondary">
                        <i class="fas fa-times me-1"></i>Cancel
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>Save Report
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
</x-app-layout>

<!-- Add this to the header for tooltips initialization -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });
});
</script>




