<div class="min-h-screen bg-[#0C0C0F] text-white flex items-center justify-center p-4">
    <div class="w-full max-w-4xl">
        {{-- Custom Progress Indicator --}}
        <div class="flex justify-between items-center mb-12 relative">
            {{-- Connection Lines --}}
            <div class="absolute top-1/2 left-0 w-full h-0.5 bg-[#1E1E20] -z-10"></div>
            <div class="absolute top-1/2 left-0 h-0.5 bg-gradient-to-r from-[#F7A600] to-[#F7A600]/80 transition-all duration-500 -z-10"
                style="width: {{ ($currentStep - 1) * 25 }}%">
            </div>

            {{-- Step Indicators --}}
            @foreach (range(1, 5) as $step)
                <div class="relative">
                    {{-- Outer Circle --}}
                    <div class="w-12 h-12 rounded-full flex items-center justify-center {{ $currentStep >= $step ? 'bg-gradient-to-r from-[#F7A600] to-[#F7A600]/80' : 'bg-[#1E1E20]' }} transition-colors duration-500">
                        {{-- Inner Content --}}
                        <div class="w-10 h-10 rounded-full bg-[#0C0C0F] flex items-center justify-center">
                            @if ($currentStep > $step)
                                <i class="fas fa-check text-[#F7A600]"></i>
                            @elseif ($currentStep == $step)
                                <div class="w-3 h-3 rounded-full bg-[#F7A600] animate-pulse"></div>
                            @else
                                <div class="w-3 h-3 rounded-full bg-[#3A3A3E]"></div>
                            @endif
                        </div>
                        {{-- Step Label --}}
                        <div class="absolute -bottom-6 left-1/2 transform -translate-x-1/2 text-xs {{ $currentStep >= $step ? 'text-[#F7A600]' : 'text-[#6B6B73]' }}">
                            @switch($step)
                                @case(1)
                                    {{ __('t.welcome') }}
                                    @break
                                @case(2)
                                    {{ __('t.deposit') }}
                                    @break
                                @case(3)
                                    {{ __('t.trading') }}
                                    @break
                                @case(4)
                                    {{ __('t.withdraw') }}
                                    @break
                                @default
                                    {{ __('t.complete') }}
                            @endswitch
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        {{-- Step Content --}}
        <div class="relative overflow-hidden" style="height: 600px">
            {{-- Welcome Step --}}
            <div x-show="$wire.currentStep === 1"
                x-transition:enter="transition duration-500 transform"
                x-transition:enter-start="translate-x-full opacity-0"
                x-transition:enter-end="translate-x-0 opacity-100"
                x-transition:leave="transition duration-500 transform"
                x-transition:leave-start="translate-x-0 opacity-100"
                x-transition:leave-end="-translate-x-full opacity-0"
                class="absolute inset-0 flex flex-col items-center justify-center text-center p-6">
                
                <div class="animate-float">
                    <div class="w-24 h-24 bg-[#F7A600]/10 rounded-full flex items-center justify-center mb-6">
                        <i class="fas fa-rocket text-[#F7A600] text-4xl"></i>
                    </div>
                </div>
                
                <h1 class="text-3xl font-bold mb-4 text-white">{{ __('t.welcome_to_site') }} {{ $settings->site_name }}!</h1>
                <p class="text-[#9CA3AF] max-w-md mb-8">{{ __('t.your_journey_starts_here') }}</p>
                
                <button wire:click="nextStep"
                    class="bg-gradient-to-r from-[#F7A600] to-[#F7A600]/80 text-black font-medium px-8 py-3 rounded-xl hover:brightness-110 transition-all flex items-center gap-2">
                    {{ __('t.lets_begin') }}
                    <i class="fas fa-arrow-right"></i>
                </button>
            </div>

            {{-- Deposit Step --}}
            <div x-show="$wire.currentStep === 2"
                x-transition:enter="transition duration-500 transform"
                x-transition:enter-start="translate-x-full opacity-0"
                x-transition:enter-end="translate-x-0 opacity-100"
                x-transition:leave="transition duration-500 transform"
                x-transition:leave-start="translate-x-0 opacity-100"
                x-transition:leave-end="-translate-x-full opacity-0"
                class="absolute inset-0 p-6">
                
                <div class="bg-[#161618] rounded-2xl p-6 transform hover:scale-[1.02] transition-transform duration-300 border border-[#1E1E20]">
                    <div class="flex items-start gap-6">
                        <div class="animate-bounce-slow">
                            <div class="w-16 h-16 bg-[#F7A600]/10 rounded-xl flex items-center justify-center">
                                <i class="fas fa-arrow-down text-[#F7A600] text-2xl mb-2"></i>
                                <p class="text-sm text-[#9CA3AF]">{{ __('t.crypto') }}</p>
                            </div>
                        </div>
                        <div class="flex-1">
                            <h2 class="text-2xl font-bold mb-2 text-white">{{ __('t.make_first_deposit') }}</h2>
                            <p class="text-[#9CA3AF] mb-6">{{ __('t.start_funding_account') }}</p>
                            
                            <div class="grid grid-cols-3 gap-4 mb-6">
                                <div class="bg-[#0C0C0F] rounded-xl p-4 text-center hover:bg-[#F7A600]/10 transition-all duration-300 cursor-pointer border border-[#1E1E20] hover:border-[#F7A600]/40 group">
                                    <i class="fab fa-bitcoin text-[#F7931A] text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                                    <p class="text-sm text-[#9CA3AF] group-hover:text-white transition-colors">{{ __('t.crypto') }}</p>
                                </div>
                                <div class="bg-[#0C0C0F] rounded-xl p-4 text-center hover:bg-[#F7A600]/10 transition-all duration-300 cursor-pointer border border-[#1E1E20] hover:border-[#F7A600]/40 group">
                                    <i class="fas fa-credit-card text-[#F7A600] text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                                    <p class="text-sm text-[#9CA3AF] group-hover:text-white transition-colors">{{ __('t.card') }}</p>
                                </div>
                                <div class="bg-[#0C0C0F] rounded-xl p-4 text-center hover:bg-[#F7A600]/10 transition-all duration-300 cursor-pointer border border-[#1E1E20] hover:border-[#F7A600]/40 group">
                                    <i class="fas fa-university text-[#F7A600] text-2xl mb-2 group-hover:scale-110 transition-transform"></i>
                                    <p class="text-sm text-[#9CA3AF] group-hover:text-white transition-colors">{{ __('t.bank') }}</p>
                                </div>
                            </div>
                            
                            <button wire:click="nextStep"
                                class="w-full bg-gradient-to-r from-[#F7A600] to-[#F7A600]/80 text-black font-medium px-6 py-3 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-2">
                                {{ __('t.continue') }}
                                <i class="fas fa-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Trading Step --}}
            <div x-show="$wire.currentStep === 3"
                x-transition:enter="transition duration-500 transform"
                x-transition:enter-start="translate-x-full opacity-0"
                x-transition:enter-end="translate-x-0 opacity-100"
                x-transition:leave="transition duration-500 transform"
                x-transition:leave-start="translate-x-0 opacity-100"
                x-transition:leave-end="-translate-x-full opacity-0"
                class="absolute inset-0 p-6">
                
                <div class="bg-[#161618] rounded-2xl p-6 transform hover:scale-[1.02] transition-transform duration-300 border border-[#1E1E20]">
                    <div class="flex items-start gap-6">
                        <div class="animate-pulse">
                            <div class="w-16 h-16 bg-[#F7A600]/10 rounded-xl flex items-center justify-center">
                                <i class="fas fa-chart-line text-[#F7A600] text-2xl"></i>
                            </div>
                        </div>
                        <div class="flex-1">
                            <h2 class="text-2xl font-bold mb-2 text-white">{{ __('t.start_trading') }}</h2>
                            <p class="text-[#9CA3AF] mb-6">{{ __('t.access_advanced_tools') }}</p>
                            
                            <div class="grid grid-cols-2 gap-4 mb-6">
                                <div class="bg-[#0C0C0F] rounded-xl p-4 flex items-center gap-3 hover:bg-[#F7A600]/10 transition-all duration-300 cursor-pointer border border-[#1E1E20] hover:border-[#F7A600]/40 group">
                                    <div class="w-10 h-10 bg-[#F7A600]/10 rounded-lg flex items-center justify-center group-hover:bg-[#F7A600]/20 transition-colors">
                                        <i class="fas fa-signal text-[#F7A600] group-hover:scale-110 transition-transform"></i>
                                    </div>
                                    <div>
                                        <h3 class="font-medium text-white group-hover:text-[#F7A600] transition-colors">{{ __('t.signals') }}</h3>
                                        <p class="text-sm text-[#9CA3AF]">{{ __('t.expert_analysis') }}</p>
                                    </div>
                                </div>
                                <div class="bg-[#0C0C0F] rounded-xl p-4 flex items-center gap-3 hover:bg-[#F7A600]/10 transition-all duration-300 cursor-pointer border border-[#1E1E20] hover:border-[#F7A600]/40 group">
                                    <div class="w-10 h-10 bg-[#F7A600]/10 rounded-lg flex items-center justify-center group-hover:bg-[#F7A600]/20 transition-colors">
                                        <i class="fas fa-robot text-[#F7A600] group-hover:scale-110 transition-transform"></i>
                                    </div>
                                    <div>
                                        <h3 class="font-medium text-white group-hover:text-[#F7A600] transition-colors">{{ __('t.auto_copy') }}</h3>
                                        <p class="text-sm text-[#9CA3AF]">{{ __('t.copy_experts') }}</p>
                                    </div>
                                </div>
                            </div>
                            
                            <button wire:click="nextStep"
                                class="w-full bg-gradient-to-r from-[#F7A600] to-[#F7A600]/80 text-black font-medium px-6 py-3 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-2">
                                {{ __('t.continue') }}
                                <i class="fas fa-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Withdrawal Step --}}
            <div x-show="$wire.currentStep === 4"
                x-transition:enter="transition duration-500 transform"
                x-transition:enter-start="translate-x-full opacity-0"
                x-transition:enter-end="translate-x-0 opacity-100"
                x-transition:leave="transition duration-500 transform"
                x-transition:leave-start="translate-x-0 opacity-100"
                x-transition:leave-end="-translate-x-full opacity-0"
                class="absolute inset-0 p-6">
                
                <div class="bg-[#161618] rounded-2xl p-6 transform hover:scale-[1.02] transition-transform duration-300 border border-[#1E1E20]">
                    <div class="flex items-start gap-6">
                        <div class="animate-ping-slow">
                            <div class="w-16 h-16 bg-[#F7A600]/10 rounded-xl flex items-center justify-center">
                                <i class="fas fa-wallet text-[#F7A600] text-2xl"></i>
                            </div>
                        </div>
                        <div class="flex-1">
                            <h2 class="text-2xl font-bold mb-2 text-white">{{ __('t.easy_withdrawals') }}</h2>
                            <p class="text-[#9CA3AF] mb-6">{{ __('t.fast_secure_withdrawals') }}</p>
                            
                            <div class="space-y-4 mb-6">
                                <div class="bg-[#0C0C0F] rounded-xl p-4 flex items-center justify-between hover:bg-[#F7A600]/10 transition-all duration-300 cursor-pointer border border-[#1E1E20] hover:border-[#F7A600]/40 group">
                                    <div class="flex items-center gap-3">
                                        <i class="fas fa-bolt text-[#F7A600] group-hover:scale-110 transition-transform"></i>
                                        <span class="text-white group-hover:text-[#F7A600] transition-colors">{{ __('t.fast_processing') }}</span>
                                    </div>
                                    <div class="text-sm text-[#9CA3AF]">{{ __('t.processing_time') }}</div>
                                </div>
                                <div class="bg-[#0C0C0F] rounded-xl p-4 flex items-center justify-between hover:bg-[#F7A600]/10 transition-all duration-300 cursor-pointer border border-[#1E1E20] hover:border-[#F7A600]/40 group">
                                    <div class="flex items-center gap-3">
                                        <i class="fas fa-shield-alt text-[#F7A600] group-hover:scale-110 transition-transform"></i>
                                        <span class="text-white group-hover:text-[#F7A600] transition-colors">{{ __('t.secure_transfer') }}</span>
                                    </div>
                                    <div class="text-sm text-[#9CA3AF]">{{ __('t.protected') }}</div>
                                </div>
                            </div>
                            
                            <button wire:click="nextStep"
                                class="w-full bg-gradient-to-r from-[#F7A600] to-[#F7A600]/80 text-black font-medium px-6 py-3 rounded-xl hover:brightness-110 transition-all flex items-center justify-center gap-2">
                                {{ __('t.continue') }}
                                <i class="fas fa-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Final Step --}}
            <div x-show="$wire.currentStep === 5"
                x-transition:enter="transition duration-500 transform"
                x-transition:enter-start="translate-x-full opacity-0"
                x-transition:enter-end="translate-x-0 opacity-100"
                x-transition:leave="transition duration-500 transform"
                x-transition:leave-start="translate-x-0 opacity-100"
                x-transition:leave-end="-translate-x-full opacity-0"
                class="absolute inset-0 flex flex-col items-center justify-center text-center p-6">
                
                <div class="animate-bounce-slow mb-8">
                    <div class="w-24 h-24 bg-[#F7A600]/10 rounded-full flex items-center justify-center">
                        <i class="fas fa-check-circle text-[#F7A600] text-4xl"></i>
                    </div>
                </div>
                
                <h1 class="text-3xl font-bold mb-4 text-white">{{ __('t.youre_all_set') }}</h1>
                <p class="text-[#9CA3AF] max-w-md mb-8">{{ __('t.account_ready') }}</p>
                
                <button wire:click="finish"
                    class="bg-gradient-to-r from-[#F7A600] to-[#F7A600]/80 text-black font-medium px-8 py-3 rounded-xl hover:brightness-110 transition-all flex items-center gap-2">
                    {{ __('t.go_to_dashboard') }}
                    <i class="fas fa-arrow-right"></i>
                </button>
            </div>
        </div>
    </div>
</div>





