<div x-data="{ privacy: 'twofactor' }" class="space-y-6">
    {{-- Navigation Tabs --}}
    <nav class="flex justify-center border-b border-gray-800">
        @can('use two-factor authentication')
            <button 
                @click="privacy = 'twofactor'"
                class="px-6 py-3 transition-colors"
                :class="privacy === 'twofactor' ? 'text-theme-primary border-b-2 border-theme-primary' : 'text-gray-400 hover:text-gray-300'">
                {{ __('t.2fa') }}
            </button>
        @endcan

        @can('manage browser sessions')
            <button 
                @click="privacy = 'browser_sessions'"
                class="px-6 py-3 transition-colors"
                :class="privacy === 'browser_sessions' ? 'text-theme-primary border-b-2 border-theme-primary' : 'text-gray-400 hover:text-gray-300'">
                {{ __('t.browser') }}
            </button>
        @endcan

        @can('delete their account')
            <button 
                @click="privacy = 'delete_account'"
                class="px-6 py-3 transition-colors"
                :class="privacy === 'delete_account' ? 'text-theme-primary border-b-2 border-theme-primary' : 'text-gray-400 hover:text-gray-300'">
               {{ __('t.delete_acc') }}
            </button>
        @endcan
    </nav>

    {{-- Content Panels --}}
    <div class="pt-4">
        @can('use two-factor authentication')
            <div x-show="privacy === 'twofactor'" x-transition>
                @livewire('profile.two-factor-authentication-form')
            </div>
        @endcan

        <div x-show="privacy === 'browser_sessions'" x-transition style="display: none">
            @livewire('profile.logout-other-browser-sessions-form')
        </div>

        <div x-show="privacy === 'delete_account'" x-transition style="display: none">
            @livewire('profile.delete-user-form')
        </div>
    </div>
</div>



