@extends('layouts.millage')

@section('title', 'Copy Trade')

@section('content')
<div class="h-full bg-theme-tertiary pt-6">
    <div class="w-full mx-auto px-4 sm:px-6 lg:px-8">
       {{-- Header Section with Summary Stats --}}
<div class="bg-theme-secondary rounded-xl p-6 mb-6">
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div>
            <h1 class="text-2xl font-medium mb-3">Copy Trading</h1>
            <p class="text-gray-400">Mirror the trades of successful traders automatically.</p>
        </div>
        <div class="col-span-2">
            <div class="grid grid-cols-3 gap-4">
                <div class="bg-theme-tertiary rounded-xl p-4">
                    <div class="text-sm text-gray-400 mb-1">Total Profit/Loss</div>
                    <div class="text-xl font-medium {{ $totalProfit >= 0 ? 'text-green-500' : 'text-red-500' }}">
                        {{ $totalProfit >= 0 ? '+' : '' }}${{ number_format($totalProfit, 2) }}
                    </div>
                </div>
                <div class="bg-theme-tertiary rounded-xl p-4">
                    <div class="text-sm text-gray-400 mb-1">Success Rate</div>
                    <div class="text-xl font-medium text-theme-primary">
                        {{ number_format($successRate, 1) }}%
                    </div>
                </div>
                <div class="bg-theme-tertiary rounded-xl p-4">
                    <div class="text-sm text-gray-400 mb-1">Active Copies</div>
                    <div class="text-xl font-medium text-theme-primary">
                        {{ count($copyingTraders) }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

        {{-- Filter Section --}}
        <div class="bg-theme-secondary rounded-xl p-4 mb-6">
            <div class="flex flex-wrap items-center gap-2">
                <div>
                    <select class="bg-theme-tertiary border border-gray-800 rounded-lg px-2 py-2 text-sm focus:outline-none focus:border-theme-primary">
                        <option value="">All Traders</option>
                        <option value="vip">VIP</option>
                        <option value="expert">Expert</option>
                        <option value="premium">Premium</option>
                        <option value="regular">Regular</option>
                    </select>
                </div>
                <div>
                    <select class="bg-theme-tertiary border border-gray-800 rounded-lg px-2 py-2 text-sm focus:outline-none focus:border-theme-primary">
                        <option value="">Win Rate</option>
                        <option value="75">Above 75%</option>
                        <option value="50">Above 50%</option>
                        <option value="25">Above 25%</option>
                    </select>
                </div>
                <div>
                    <select class="bg-theme-tertiary border border-gray-800 rounded-lg px-2 py-2 text-sm focus:outline-none focus:border-theme-primary">
                        <option value="">Sort By</option>
                        <option value="win_rate">Win Rate</option>
                        <option value="total_trades">Total Trades</option>
                        <option value="profit">Total Profit</option>
                    </select>
                </div>
            </div>
        </div>

        {{-- Traders Grid --}}
        <div class="grid grid-cols-1 md:grid-cols-2 pb-4 xl:grid-cols-3 gap-6">
            @foreach($traders as $trader)
            <div class="bg-theme-secondary rounded-xl overflow-hidden">
                {{-- Trader Header --}}
                <div class="p-4 border-b border-gray-800/50">
                    <div class="flex items-start justify-between">
                        <div class="flex items-center gap-4">
                            <div class="relative">
                                @if($trader->profile_photo_path)
                                    <img src="{{ Storage::url($trader->profile_photo_path) }}"
                                        alt="{{ $trader->name }}"
                                        class="w-12 h-12 rounded-xl object-cover">
                                @else
                                    <div class="w-12 h-12 rounded-xl bg-gray-800 flex items-center justify-center">
                                        <i class="fas fa-user text-gray-600"></i>
                                    </div>
                                @endif
                                @if($trader->trader_type)
                                    <div class="absolute -bottom-2 -right-2">
                                        <div class="bg-{{ $trader->trader_type->color() }}-500/20 
                                             text-{{ $trader->trader_type->color() }}-500 
                                             text-xs px-2 py-0.5 rounded-full border 
                                             border-{{ $trader->trader_type->color() }}-500/50">
                                            {{ $trader->trader_type->label() }}
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div>
                                <h3 class="font-medium flex items-center gap-2">
                                    {{ $trader->name }}
                                    @if($trader->trader_type === 'vip' || $trader->trader_type === 'expert')
                                        <i class="fas fa-check-circle text-theme-primary text-sm"></i>
                                    @endif
                                </h3>
                                <p class="text-sm text-gray-400">Joined {{ $trader->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Trader Stats --}}
                <div class="p-4">
                    <div class="grid grid-cols-2 gap-4 mb-4">
                        <div>
                            <div class="text-sm text-gray-400 mb-1">Total Profit</div>
                            <div class="text-lg font-medium text-green-500">+${{ number_format($trader->total_profit, 2) }}</div>
                        </div>
                        <div>
                            <div class="text-sm text-gray-400 mb-1">ROI</div>
                            <div class="text-lg font-medium text-theme-primary">{{ number_format($trader->roi, 2) }}%</div>
                        </div>
                    </div>

                    <div class="grid grid-cols-3 gap-4">
                        <div class="bg-theme-tertiary rounded-lg p-3 text-center">
                            <div class="text-green-500 font-medium">{{ $trader->total_wins }}</div>
                            <div class="text-xs text-gray-400">Won</div>
                        </div>
                        <div class="bg-theme-tertiary rounded-lg p-3 text-center">
                            <div class="text-red-500 font-medium">{{ $trader->total_losses }}</div>
                            <div class="text-xs text-gray-400">Lost</div>
                        </div>
                        <div class="bg-theme-tertiary rounded-lg p-3 text-center">
                            <div class="text-theme-primary font-medium">{{ number_format($trader->win_rate, 1) }}%</div>
                            <div class="text-xs text-gray-400">Win Rate</div>
                        </div>
                    </div>

                    {{-- Copy Button --}}
                    <div class="mt-4" x-data="{ showCopyModal: false }">
                        <button
    @click="{{ in_array($trader->id, $copyingTraders) ? 'stopCopying('.$trader->id.')' : 'showCopyModal = true' }}"
    class="w-full {{ in_array($trader->id, $copyingTraders) 
        ? 'bg-red-500/10 text-red-500 hover:bg-red-500/20' 
        : 'bg-theme-primary text-black hover:brightness-110' }} 
        px-4 py-3 rounded-lg text-sm font-medium transition-all"
    data-trader-id="{{ $trader->id }}">
    {{ in_array($trader->id, $copyingTraders) ? 'Stop Copying' : 'Copy Trader' }}
</button>


                        {{-- Copy Settings Modal --}}
                        <div x-show="showCopyModal"
                            x-cloak
                            @click.away="showCopyModal = false"
                            class="fixed inset-0 z-50 overflow-y-auto"
                            x-transition:enter="transition ease-out duration-300"
                            x-transition:enter-start="opacity-0"
                            x-transition:enter-end="opacity-100"
                            x-transition:leave="transition ease-in duration-200"
                            x-transition:leave-start="opacity-100"
                            x-transition:leave-end="opacity-0">
                            <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
                                <div class="fixed inset-0 transition-opacity bg-gray-900 bg-opacity-75" aria-hidden="true"></div>
                                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                                <div class="inline-block w-full max-w-md p-6 my-8 overflow-hidden text-left align-middle transition-all transform bg-theme-secondary rounded-xl shadow-xl">
                                    <div class="flex items-start justify-between mb-4">
                                        <h3 class="text-lg font-medium">Copy Trade Settings</h3>
                                        <button @click="showCopyModal = false" class="text-gray-400 hover:text-white">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>

                                    <div class="space-y-4">
                                        {{-- Amount Input --}}
                                        <div>
                                            <label class="block text-sm text-gray-400 mb-1">Amount per Trade</label>
                                            <div class="relative">
                                                <input
                                                    type="number"
                                                    class="w-full bg-theme-tertiary border border-gray-800 rounded-lg pl-8 pr-4 py-2 text-sm focus:outline-none focus:border-theme-primary"
                                                    placeholder="Enter amount"
                                                    min="1">
                                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                                    <span class="text-gray-400">$</span>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Duration Select --}}
                                        <div>
                                            <label class="block text-sm text-gray-400 mb-1">Trade Duration</label>
                                            <select class="w-full bg-theme-tertiary border border-gray-800 rounded-lg px-4 py-2 text-sm focus:outline-none focus:border-theme-primary">
                                                <option value="default">Same as Trader</option>
                                                <option value="1m">1 Minute</option>
                                                <option value="5m">5 Minutes</option>
                                                <option value="15m">15 Minutes</option>
                                                <option value="30m">30 Minutes</option>
                                                <option value="1h">1 Hour</option>
                                                <option value="4h">4 Hours</option>
                                                <option value="1d">1 Day</option>
                                            </select>
                                        </div>

                                        {{-- Info Box --}}
                                        <div class="bg-blue-500/10 border border-blue-500/20 rounded-lg p-3 text-sm text-blue-500">
                                            <div class="flex items-start gap-2">
                                                <i class="fas fa-info-circle mt-0.5"></i>
                                                <div>
                                                    Your account will automatically copy this trader's positions with your specified settings.
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Action Buttons --}}
                                        <div class="flex justify-end gap-3 mt-6">
                                            <button
                                                @click="showCopyModal = false"
                                                class="px-4 py-2 border border-gray-800 rounded-lg text-sm text-gray-400 hover:text-white transition-colors">
                                                Cancel
                                            </button>
                                            <button
                                                onclick="startCopying({{ $trader->id }})"
                                                class="px-4 py-2 bg-theme-primary text-black text-sm font-medium rounded-lg hover:brightness-110 transition-all">
                                                Start Copying
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>

        {{-- Pagination --}}
        @if($traders->hasPages())
            <div class="mt-6">
                {{ $traders->links() }}
            </div>
        @endif
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    async function startCopying(traderId) {
        const modal = document.querySelector(`[data-trader-id="${traderId}"]`).closest('div').querySelector('[x-show="showCopyModal"]');
        const amount = modal.querySelector('input[type="number"]').value;
        const duration = modal.querySelector('select').value;

        try {
            const response = await fetch(`/user/copy-trader/start/${traderId}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                },
                body: JSON.stringify({
                    amount_per_trade: amount,
                    duration: duration
                })
            });

            const data = await response.json();

            if (data.success) {
                Swal.fire({
                    title: 'Success',
                    text: data.message,
                    icon: 'success',
                    background: 'var(--color-background-tertiary)',
                    confirmButtonColor: 'var(--color-primary)'
                });
                
                window.location.reload();
            } else {
                throw new Error(data.message);
            }

        } catch (error) {
            Swal.fire({
                title: 'Error',
                text: error.message || 'Failed to start copying trader',
                icon: 'error',
                background: 'var(--color-background-tertiary)',
                color: 'white',
                confirmButtonColor: 'var(--color-primary)'
            });
        }
    }

    async function stopCopying(traderId) {
        try {
            const response = await fetch(`/user/copy-trader/stop/${traderId}`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                }
            });

            const data = await response.json();

            if (data.success) {
                Swal.fire({
                    title: 'Success',
                    text: data.message,
                    icon: 'success',
                    background: 'var(--color-background-tertiary)',
                    color: 'white',
                    confirmButtonColor: 'var(--color-primary)'
                });
                
                window.location.reload();
            } else {
                throw new Error(data.message);
            }

        } catch (error) {
            Swal.fire({
                title: 'Error',
                text: error.message || 'Failed to stop copying trader',
                icon: 'error',
                background: 'var(--color-background-tertiary)',
                confirmButtonColor: 'var(--color-primary)'
            });
        }
    }

    // Handle filter changes
    document.querySelectorAll('select').forEach(select => {
        select.addEventListener('change', function() {
            const filters = {
                trader_type: document.querySelector('select[value=""]').value,
                win_rate: document.querySelector('select[value=""]').value,
                sort_by: document.querySelector('select[value=""]').value
            };

            const queryString = new URLSearchParams(filters).toString();
            window.location.href = `${window.location.pathname}?${queryString}`;
        });
    });

    // Add to window object for onclick access
    window.startCopying = startCopying;
    window.stopCopying = stopCopying;
});
</script>

<style>
[x-cloak] {
    display: none !important;
}

.modal-backdrop {
    background-color: rgba(0, 0, 0, 0.75);
}
</style>
@endsection



